/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.rework.jars;

import com.azul.crs.client.Options;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Tweaks;
import com.azul.crs.client.Utils;
import com.azul.crs.client.rework.jars.MonitorService;
import com.azul.crs.runtime.utils.TempFilesFactory;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class TempFilesMonitor
extends MonitorService {
    private static final long maxLimit = 1024L * Options.maxJarFileCacheSize.getLong();
    private final AtomicLong currentLimit = new AtomicLong(maxLimit);
    private final TempFilesFactory.TempFile dummy = null;
    private final Queue<TempFileRequest> queue = new ConcurrentLinkedQueue<TempFileRequest>();
    private final Logger logger = Logger.getLogger(this.getClass());

    @Override
    public void start() {
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.logger.trace("stop (ntd) finished, exiting, deadline=%s, unfinished temp file requests=%d, current limit=%d", deadline, this.queue.size(), this.currentLimit.get());
        if (Tweaks.DEBUG_JARLOAD) {
            for (TempFileRequest tempFileRequest : this.queue) {
                this.logger.trace("unfinished temp file request: %s", tempFileRequest);
            }
        }
        this.queue.clear();
    }

    @Override
    public void cancel() {
    }

    private TempFilesFactory.TempFile createTempFile(TempFileRequest tempFileRequest) throws IOException {
        long l = this.currentLimit.addAndGet(-tempFileRequest.size);
        if (l < 0L) {
            this.currentLimit.addAndGet(tempFileRequest.size);
            return null;
        }
        TempFilesFactory.TempFile tempFile2 = TempFilesFactory.createTempJarFile(tempFile -> {
            this.logger.trace("on tempfile delete: %s [%d]", Objects.toString(tempFile), tempFileRequest.size);
            PerformanceMetrics.logJarCacheDeleted(tempFileRequest.size);
            this.currentLimit.addAndGet(tempFileRequest.size);
            try {
                this.retryPostponed();
            }
            catch (Exception exception) {
                this.logger.error("onRelease method failed: %s", exception);
            }
        });
        if (tempFile2 != null) {
            PerformanceMetrics.logJarCacheCreated(tempFileRequest.size);
        } else {
            this.currentLimit.addAndGet(tempFileRequest.size);
        }
        return tempFile2;
    }

    public synchronized boolean expectingRequests() {
        return Tweaks.WAIT_ALL_JAR_REQUESTS && this.queue.size() > 0;
    }

    private synchronized void retryPostponed() throws IOException {
        TempFileRequest tempFileRequest = null;
        ArrayList<TempFileRequest> arrayList = new ArrayList<TempFileRequest>();
        while (null != (tempFileRequest = this.queue.poll())) {
            TempFilesFactory.TempFile tempFile = this.createTempFile(tempFileRequest);
            if (tempFile != null) {
                tempFileRequest.accept(tempFile, null);
                continue;
            }
            arrayList.add(tempFileRequest);
        }
        this.queue.addAll(arrayList);
    }

    public void waitFor(ExecutorService executorService, long l, Consumer<TempFilesFactory.TempFile> consumer) {
        this.logger.trace("requested temp file with size %d", l);
        if (l == 0L) {
            consumer.accept(this.dummy);
            return;
        }
        if (l > maxLimit) {
            throw new RuntimeException("unexpected request size=" + l + " > maxLimit=" + maxLimit);
        }
        try {
            TempFileRequest tempFileRequest = new TempFileRequest(executorService, l, consumer);
            TempFilesFactory.TempFile tempFile = this.createTempFile(tempFileRequest);
            if (tempFile != null) {
                consumer.accept(tempFile);
            } else {
                if (this.queue.size() > Tweaks.jarLoadMonitorTaskQueueSize) {
                    this.logger.error("TempFilesMonitor queue limit has been reached (%d)", Tweaks.jarLoadMonitorTaskQueueSize);
                    throw new RuntimeException("limit reached: TempFilesMontor.queue.size[" + this.queue.size() + "] > Tweaks.jarLoadMonitorTaskQueueSize[" + Tweaks.jarLoadMonitorTaskQueueSize + "]");
                }
                PerformanceMetrics.logJarLoadPostponedDueToNoSpaceYet();
                this.queue.add(new TempFileRequest(executorService, l, consumer));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("temp file is not allocated (size=" + l + "): ", iOException);
        }
    }

    private static class TempFileRequest {
        public final long size;
        public final ExecutorService executor;
        public final Consumer<TempFilesFactory.TempFile> consumer;
        public final long ms;

        public TempFileRequest(ExecutorService executorService, long l, Consumer<TempFilesFactory.TempFile> consumer) {
            this.executor = executorService;
            this.size = l;
            this.consumer = consumer;
            this.ms = Utils.currentTimeMillis();
        }

        public String toString() {
            return "TempFileRequest[" + this.size + "]";
        }

        public void accept(TempFilesFactory.TempFile tempFile, Exception exception) {
            PerformanceMetrics.logJarWaitingTime(Utils.currentTimeMillis() - this.ms);
            if (this.executor != null) {
                this.executor.submit(() -> this.consumer.accept(tempFile));
            } else {
                this.consumer.accept(tempFile);
            }
        }
    }
}

