/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.util.logging;

import com.azul.crs.client.Tweaks;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public final class Logger {
    private static final String REGISTRY = "META-INF/crslog.channels.cfg";
    private static final Map<String, Logger> TAG_TO_LOGGER = new HashMap<String, Logger>();
    private static final Map<String, String> CLASS_TO_TAG = new HashMap<String, String>();
    private static boolean registryLoaded = false;
    private static final List<PrintWriter> writers = new CopyOnWriteArrayList<PrintWriter>();
    private static final long vmStartTime = System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getUptime();
    private static Level globalLevel = Level.ERROR;
    private static boolean globalShowStacktrace = false;
    private static boolean globalShowTimestamp = false;
    private final String tag;
    private final Level lowestUpstreamLevel;
    private Level level = null;
    private Boolean showStacktrace = null;
    private static Logger defaultLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void readRegistry() {
        if (registryLoaded) {
            return;
        }
        String string = Logger.class.getName().replace(".util.logging.Logger", "");
        int n = string.length();
        boolean bl = n > 12;
        try {
            HashSet<URL> hashSet = new HashSet<URL>();
            ClassLoader classLoader = Logger.class.getClassLoader();
            if (classLoader != null) {
                hashSet.addAll(Collections.list(classLoader.getResources(REGISTRY)));
            }
            hashSet.addAll(Collections.list(ClassLoader.getSystemResources(REGISTRY)));
            for (URL uRL : hashSet) {
                Properties properties = new Properties();
                InputStream inputStream = uRL.openStream();
                Throwable throwable = null;
                try {
                    properties.load(inputStream);
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string2;
                        String string3 = enumeration.nextElement().toString();
                        String string4 = properties.getProperty(string3);
                        Level level = Level.DEBUG;
                        int n2 = string4.lastIndexOf(58);
                        if (n2 > 0) {
                            string2 = string4.substring(0, n2);
                            level = Level.valueOf(string4.substring(n2 + 1));
                        } else {
                            string2 = string4;
                        }
                        TAG_TO_LOGGER.put(string2, new Logger(string2, level));
                        if (bl) {
                            string3 = string + string3.substring(12);
                        }
                        CLASS_TO_TAG.put(string3, string2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        catch (Throwable throwable) {
            java.util.logging.Logger.getLogger(Logger.class.getName()).log(java.util.logging.Level.SEVERE, null, throwable);
        }
        finally {
            registryLoaded = true;
        }
    }

    static void reset() {
        CLASS_TO_TAG.clear();
        TAG_TO_LOGGER.clear();
        globalLevel = Level.ERROR;
        globalShowStacktrace = false;
        globalShowTimestamp = false;
        registryLoaded = false;
    }

    private Logger(String string, Level level) {
        this.tag = string;
        this.lowestUpstreamLevel = level;
    }

    private static Logger loggerForTag(String string) {
        return TAG_TO_LOGGER.get(string);
    }

    public static void addOutputStream(OutputStream outputStream) {
        writers.add(new PrintWriter(outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger getDefaultLogger() {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (defaultLogger == null) {
                defaultLogger = new Logger("default", Level.TRACE);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultLogger;
        }
    }

    public static Logger getLogger(Class clazz) {
        String string = clazz.getCanonicalName();
        String string2 = CLASS_TO_TAG.get(string);
        if (string2 == null) {
            Logger.readRegistry();
            string2 = CLASS_TO_TAG.get(string);
        }
        return string2 == null ? Logger.getDefaultLogger() : Logger.loggerForTag(string2);
    }

    public static void parseOption(String string, String string2) {
        Level level;
        Logger.readRegistry();
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            int n;
            if (string2.endsWith("+stack")) {
                bl = true;
                n = 6;
            } else {
                if (!string2.endsWith("+time")) break;
                bl2 = true;
                n = 5;
            }
            string2 = string2.substring(0, string2.length() - n);
        }
        try {
            level = Level.valueOf(string2.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("[CRS.log][error] unsupported log level '" + string2 + "'");
            return;
        }
        if (string.equals("log")) {
            globalLevel = level;
            globalShowStacktrace = bl;
        } else if (string.startsWith("log+")) {
            String string3 = string.substring(4);
            if (!"vm".equals(string3)) {
                Logger logger = Logger.loggerForTag(string3);
                if (logger != null) {
                    logger.setLevel(level).setShowStacktrace(bl);
                } else {
                    System.err.println("[CRS.log][error] unknown CRS log channel " + string.substring(4));
                }
            }
        } else {
            System.err.println("[CRS.log][error] unknown CRS log option " + string);
            return;
        }
        if (bl2 && !globalShowTimestamp) {
            globalShowTimestamp = true;
        }
    }

    private boolean isLogLevelEnabled(Level level) {
        return this.getLevel().ordinal() <= level.ordinal();
    }

    private boolean isUpsreamLevelEnabled(Level level) {
        return this.lowestUpstreamLevel.ordinal() <= level.ordinal();
    }

    public boolean isEnabled(Level level) {
        if (this.getLevel().equals((Object)Level.OFF)) {
            return false;
        }
        return !writers.isEmpty() || this.isLogLevelEnabled(level);
    }

    private Logger setLevel(Level level) {
        this.level = level;
        return this;
    }

    private Logger setShowStacktrace(boolean bl) {
        this.showStacktrace = bl;
        return this;
    }

    boolean showStacktrace() {
        return this.showStacktrace == null ? globalShowStacktrace : this.showStacktrace;
    }

    boolean showTimestamp() {
        return globalShowTimestamp;
    }

    public Level getLevel() {
        return this.level == null ? globalLevel : this.level;
    }

    public void trace(String string, Object ... objectArray) {
        this.log(Level.TRACE, string, objectArray);
    }

    public void debug(String string, Object ... objectArray) {
        this.log(Level.DEBUG, string, objectArray);
    }

    public void info(String string, Object ... objectArray) {
        this.log(Level.INFO, string, objectArray);
    }

    public void warning(String string, Object ... objectArray) {
        this.log(Level.WARNING, string, objectArray);
    }

    public void error(String string, Object ... objectArray) {
        this.log(Level.ERROR, string, objectArray);
    }

    public void log(Level level, String string, Object ... objectArray) {
        try {
            boolean bl = this.isLogLevelEnabled(level);
            boolean bl2 = this.isUpsreamLevelEnabled(level);
            if (!bl2 && !bl) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.showTimestamp()) {
                stringBuilder.append(this.elapsedTime());
            }
            stringBuilder.append("[CRS.").append(this.tag).append("][").append(level.n).append("] ");
            if (this.getLevel() == Level.TRACE) {
                Throwable throwable = new Throwable();
                StackTraceElement object = throwable.getStackTrace()[2];
                stringBuilder.append(object.getClassName()).append('.').append(object.getMethodName()).append(": ");
            }
            if (bl) {
                this.logDecoratedLines(level, new PrintWriter(System.err), stringBuilder, string, objectArray);
            }
            if (bl2) {
                if (!this.showTimestamp()) {
                    stringBuilder.insert(0, this.elapsedTime());
                }
                for (PrintWriter printWriter : writers) {
                    this.logDecoratedLines(level, printWriter, stringBuilder, string, objectArray);
                }
            }
        }
        catch (Throwable throwable) {
            java.util.logging.Logger.getLogger(Logger.class.getName()).log(java.util.logging.Level.SEVERE, null, throwable);
        }
    }

    private CharSequence elapsedTime() {
        long l = System.currentTimeMillis() - vmStartTime;
        long l2 = l / 1000L;
        long l3 = l % 1000L;
        CharSequence charSequence = Long.toString(1000L + l3).subSequence(1, 4);
        return l2 + "." + charSequence + ": ";
    }

    private String newLineIndentation(StringBuilder stringBuilder, int n, String string) {
        stringBuilder.append("\n");
        stringBuilder.append(string);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("    ");
        }
        return stringBuilder.toString();
    }

    private String prettyPrint(String string) {
        return this.prettyPrint(string, "");
    }

    private String prettyPrint(String string, String string2) {
        if (!Tweaks.UGLY_PRETTY_PRINT_FOR_DEBUG || string == null || string.length() < 80) {
            return string;
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (i < cArray.length - 4 && cArray[i] == '\t' && cArray[i + 1] == 'a' && cArray[i + 2] == 't' && cArray[i + 3] == ' ') {
                bl = true;
            }
            if (!bl) {
                if (c == '(' || c == '[' || c == '{') {
                    int n2;
                    for (n2 = i + 1; n2 < cArray.length - 1 && "([{)]},".indexOf(cArray[n2]) == -1; ++n2) {
                    }
                    if (n2 < cArray.length - 1 && "([{".indexOf(c) == ")]}".indexOf(cArray[n2])) {
                        while (i <= n2) {
                            stringBuilder.append(cArray[i]);
                            ++i;
                        }
                        i = n2;
                        continue;
                    }
                    this.newLineIndentation(stringBuilder, n, string2);
                    stringBuilder.append(c);
                    this.newLineIndentation(stringBuilder, ++n, string2);
                    continue;
                }
                if (c == ')' || c == ']' || c == '}') {
                    this.newLineIndentation(stringBuilder, --n, string2);
                    stringBuilder.append(c);
                    this.newLineIndentation(stringBuilder, n, string2);
                    continue;
                }
                if (c == ',') {
                    stringBuilder.append(c);
                    this.newLineIndentation(stringBuilder, n, string2);
                    continue;
                }
            }
            if (i != cArray.length - 1 && c == '\n') {
                this.newLineIndentation(stringBuilder, n, string2);
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void logDecoratedLines(Level level, PrintWriter printWriter, StringBuilder stringBuilder, String string2, Object ... objectArray) {
        boolean bl;
        printWriter.append(stringBuilder);
        for (char n : this.prettyPrint(String.format(string2, objectArray)).toCharArray()) {
            printWriter.append(n);
            if (n != '\n') continue;
            printWriter.append(stringBuilder);
        }
        printWriter.println();
        boolean bl2 = bl = level == Level.ERROR && Tweaks.FORCE_PRINT_STACKTRACE_IN_ERROR;
        if (this.showStacktrace() || bl) {
            void var9_13;
            Object[] objectArray2 = objectArray;
            int n = objectArray2.length;
            boolean bl3 = false;
            while (var9_13 < n) {
                Object object = objectArray2[var9_13];
                if (object instanceof Throwable) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter2 = new PrintWriter(stringWriter);
                    ((Throwable)object).printStackTrace(printWriter2);
                    String string3 = Arrays.stream(this.prettyPrint(stringWriter.toString(), " >> ").split("\n")).map(string -> "" + stringBuilder.toString() + string).collect(Collectors.joining("\n"));
                    printWriter.append(string3);
                }
                ++var9_13;
            }
        }
        printWriter.flush();
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        OFF;

        private final String n = this.name().toLowerCase();
    }
}

