/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content;

import java.awt.Component;
import java.io.IOException;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DeallocateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RateChangeEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.StartEvent;
import javax.media.StopByRequestEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.TransitionEvent;
import javax.media.protocol.DataSource;
import javax.tv.locator.Locator;
import javax.tv.service.selection.ServiceContentHandler;
import org.bluray.media.OverallGainControl;
import org.davic.media.MediaTimePositionChangedEvent;
import org.videolan.BDJAction;
import org.videolan.BDJActionManager;
import org.videolan.BDJActionQueue;
import org.videolan.BDJListeners;
import org.videolan.BDJXletContext;
import org.videolan.Logger;
import org.videolan.media.content.PlayerManager;

public abstract class BDHandler
implements Player,
ServiceContentHandler {
    public static final int GAIN_OVERALL = 1;
    public static final int GAIN_PRIMARY = 2;
    public static final int GAIN_SECONDARY = 3;
    protected int state = 100;
    protected int targetState = 100;
    protected Time stopTime = Clock.RESET;
    protected long baseMediaTime = 0L;
    protected long baseTime;
    protected float rate = 1.0f;
    protected Control[] controls = null;
    private BDJListeners listeners = new BDJListeners();
    private BDJXletContext ownerContext = BDJXletContext.getCurrentContext();
    boolean isClosed = false;
    protected BDJActionQueue commandQueue;
    public static final double TO_SECONDS = 1.1111111111111112E-5;
    public static final double FROM_SECONDS = 90000.0;
    public static final double TO_NAROSECONDS = 11111.111111111111;
    public static final double FROM_NAROSECONDS = 9.0E-5;

    public BDHandler() {
        if (this.ownerContext == null) {
            this.doInitAction();
        } else {
            PlayerAction action = new PlayerAction(this, 1, null);
            BDJActionManager.getInstance().putCommand(action);
            action.waitEnd();
        }
    }

    private void doInitAction() {
        this.commandQueue = BDJActionQueue.create("MediaPlayer");
        PlayerManager.getInstance().registerPlayer(this);
    }

    protected BDJXletContext getOwnerContext() {
        return this.ownerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnrealized() {
        BDHandler bDHandler = this;
        synchronized (bDHandler) {
            if (this.state == 100) {
                throw new NotRealizedError("Player Unrealized");
            }
        }
    }

    public abstract void setSource(DataSource var1) throws IOException, IncompatibleSourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        BDHandler bDHandler = this;
        synchronized (bDHandler) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTargetState() {
        Logger.unimplemented("BDHandler", "getTargetState()");
        BDHandler bDHandler = this;
        synchronized (bDHandler) {
            return this.targetState;
        }
    }

    public Control[] getControls() {
        return this.controls;
    }

    public Control getControl(String forName) {
        try {
            Class<?> cls = Class.forName(forName);
            for (int i = 0; i < this.controls.length; ++i) {
                if (!cls.isInstance(this.controls[i])) continue;
                return this.controls[i];
            }
            Logger.getLogger("BDHandler").error("getControl(): control not found: " + forName);
            return null;
        }
        catch (ClassNotFoundException e) {
            Logger.getLogger("BDHandler").error("getControl(): " + e);
            return null;
        }
    }

    public GainControl getGainControl() {
        this.checkUnrealized();
        for (int i = 0; i < this.controls.length; ++i) {
            if (!(this.controls[i] instanceof OverallGainControl)) continue;
            return (GainControl)this.controls[i];
        }
        return null;
    }

    public void addController(Controller newController) throws IncompatibleTimeBaseException {
        this.checkUnrealized();
    }

    public void removeController(Controller oldController) {
        this.checkUnrealized();
    }

    public Component getControlPanelComponent() {
        this.checkUnrealized();
        return null;
    }

    public Component getVisualComponent() {
        this.checkUnrealized();
        return null;
    }

    public void addControllerListener(ControllerListener listener) {
        this.listeners.add(listener);
    }

    public void removeControllerListener(ControllerListener listener) {
        this.listeners.remove(listener);
    }

    public Time getStartLatency() {
        this.checkUnrealized();
        return new Time(0.1);
    }

    public TimeBase getTimeBase() {
        this.checkUnrealized();
        return Manager.getSystemTimeBase();
    }

    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        this.checkUnrealized();
        throw new IncompatibleTimeBaseException();
    }

    public Time getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(Time stopTime) {
        this.checkUnrealized();
        this.stopTime = stopTime;
        this.postStopTimeChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getMediaTime() {
        BDHandler bDHandler = this;
        synchronized (bDHandler) {
            if (this.state == 600) {
                return new Time((double)(this.baseMediaTime + (this.getTimeBase().getNanoseconds() - this.baseTime)) / 1.0E9);
            }
            return new Time((double)this.baseMediaTime / 1.0E9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMediaNanoseconds() {
        BDHandler bDHandler = this;
        synchronized (bDHandler) {
            if (this.state == 600 && this.rate != 0.0f) {
                return this.baseMediaTime + (this.getTimeBase().getNanoseconds() - this.baseTime);
            }
            return this.baseMediaTime;
        }
    }

    public Time getSyncTime() {
        return this.getMediaTime();
    }

    public void setMediaTime(Time now) {
        this.checkUnrealized();
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 8, (Object)now);
        this.commandQueue.put(action);
        action.waitEnd();
    }

    public void setMediaTimePosition(Time mediaTime) {
        this.setMediaTime(mediaTime);
        this.postMediaTimePositionChangedEvent();
    }

    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        if (this.state != 600) {
            throw new ClockStoppedException();
        }
        return this.getMediaTime();
    }

    public abstract Time getDuration();

    protected void updateTime(Time now) {
        this.baseMediaTime = now.getNanoseconds();
        this.baseTime = this.getTimeBase().getNanoseconds();
    }

    public float getRate() {
        return this.rate;
    }

    public float setRate(float factor) {
        this.checkUnrealized();
        PlayerAction action = new PlayerAction(this, 9, (Object)Float.valueOf(factor));
        this.commandQueue.put(action);
        action.waitEnd();
        return this.rate;
    }

    public void setGain(int mixer, boolean mute, float level) {
        Logger.unimplemented("BDHandler", "setGain");
    }

    public void setPanning(float x, float y) {
        Logger.unimplemented("BDHandler", "setPanning");
    }

    public Locator[] getServiceContentLocators() {
        return new Locator[0];
    }

    public void realize() {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 2, null);
        this.commandQueue.put(action);
    }

    public void prefetch() {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 3, null);
        this.commandQueue.put(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStart(Time at) {
        BDHandler bDHandler = this;
        synchronized (bDHandler) {
            if (this.state != 500) {
                throw new NotPrefetchedError("syncStart");
            }
        }
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 4, (Object)at);
        this.commandQueue.put(action);
    }

    public void start() {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 4, null);
        this.commandQueue.put(action);
    }

    public void stop() {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 5, null);
        this.commandQueue.put(action);
        action.waitEnd();
    }

    public void deallocate() {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 6, null);
        this.commandQueue.put(action);
        action.waitEnd();
        PlayerManager.getInstance().releaseResource(this);
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.stop();
        this.deallocate();
        PlayerAction action = new PlayerAction(this, 7, null);
        this.commandQueue.put(action);
        action.waitEnd();
        this.isClosed = true;
        this.commandQueue.shutdown();
    }

    protected boolean statusEvent(int event, int param) {
        if (this.isClosed) {
            return false;
        }
        this.commandQueue.put(new PlayerAction(this, 10, event, param));
        return true;
    }

    protected void doRateChanged(float rate) {
        if (this.rate != rate) {
            this.rate = rate;
            this.notifyListeners(new RateChangeEvent(this, rate));
        }
    }

    protected void doTimeChanged(int time) {
    }

    protected void doEndOfMediaReached(int playlist) {
        if (this.state == 600) {
            ControllerErrorEvent error = this.doStop(true);
            if (error == null) {
                this.state = 500;
                this.notifyListeners(new EndOfMediaEvent(this, 600, 500, 500, this.getMediaTime()));
            } else {
                this.notifyListeners(error);
            }
        }
    }

    protected void doSeekNotify(long tick) {
        this.updateTime(new Time((double)tick * 1.1111111111111112E-5));
    }

    protected void doPlaylistStarted(int playlist) {
    }

    protected void doChapterReached(int chapter) {
    }

    protected void doMarkReached(int playmark) {
    }

    protected void doPlayItemReached(int playitem) {
    }

    protected void doAngleChanged(int angle) {
    }

    protected void doSubtitleChanged(int param) {
    }

    protected void doAudioStreamChanged(int param) {
    }

    protected void doUOMasked(int position) {
    }

    protected void doSecondaryStreamChanged(int param) {
    }

    protected ControllerErrorEvent doRealize() {
        return null;
    }

    protected ControllerErrorEvent doPrefetch() {
        return null;
    }

    protected ControllerErrorEvent doStart(Time at) {
        if (at != null) {
            this.baseMediaTime = at.getNanoseconds();
        }
        this.baseTime = this.getTimeBase().getNanoseconds();
        return null;
    }

    protected ControllerErrorEvent doStop(boolean eof) {
        this.baseMediaTime = this.getMediaNanoseconds();
        this.rate = 1.0f;
        return null;
    }

    protected ControllerErrorEvent doDeallocate() {
        return null;
    }

    protected ControllerErrorEvent doClose() {
        return null;
    }

    protected void doSeekTime(Time at) {
        this.updateTime(at);
    }

    protected void doSetRate(Float factor) {
        if (this.rate != factor.floatValue()) {
            this.rate = factor.floatValue();
            this.notifyListeners(new RateChangeEvent(this, this.rate));
        }
    }

    private void postStopTimeChangeEvent() {
        this.notifyListeners(new StopTimeChangeEvent(this, this.getStopTime()));
    }

    protected void postMediaTimePositionChangedEvent() {
        this.notifyListeners(new MediaTimePositionChangedEvent(this, this.getState(), this.getState(), this.getState(), this.getMediaTime()));
    }

    private void notifyListeners(ControllerEvent event) {
        this.listeners.putCallback(event);
    }

    private boolean doRealizeAction() {
        switch (this.state) {
            case 100: {
                this.state = 200;
                this.notifyListeners(new TransitionEvent(this, 100, 200, 300));
            }
            case 200: {
                ControllerErrorEvent error = this.doRealize();
                if (error == null) {
                    this.state = 300;
                    this.notifyListeners(new RealizeCompleteEvent(this, 200, 300, 300));
                    break;
                }
                this.notifyListeners(error);
                return false;
            }
            default: {
                this.notifyListeners(new RealizeCompleteEvent(this, this.state, this.state, this.state));
            }
        }
        return true;
    }

    private boolean doPrefetchAction() {
        switch (this.state) {
            case 100: 
            case 200: {
                if (!this.doRealizeAction()) {
                    return false;
                }
            }
            case 300: {
                this.state = 400;
                this.notifyListeners(new TransitionEvent(this, 300, 400, 500));
            }
            case 400: {
                if (!PlayerManager.getInstance().allocateResource(this)) {
                    this.notifyListeners(new ResourceUnavailableEvent(this));
                    return false;
                }
                ControllerErrorEvent error = this.doPrefetch();
                if (error == null) {
                    this.state = 500;
                    this.notifyListeners(new PrefetchCompleteEvent(this, 400, 500, 500));
                    break;
                }
                this.notifyListeners(error);
                return false;
            }
            default: {
                this.notifyListeners(new PrefetchCompleteEvent(this, this.state, this.state, this.state));
            }
        }
        return true;
    }

    private boolean doStartAction(Time at) {
        switch (this.state) {
            case 100: 
            case 200: {
                if (!this.doRealizeAction()) {
                    return false;
                }
            }
            case 300: 
            case 400: {
                if (!this.doPrefetchAction()) {
                    return false;
                }
            }
            case 500: {
                ControllerErrorEvent error = this.doStart(at);
                if (error == null) {
                    this.state = 600;
                    this.notifyListeners(new StartEvent(this, 500, 600, 600, at, this.getMediaTime()));
                    break;
                }
                this.notifyListeners(error);
                return false;
            }
            default: {
                this.notifyListeners(new StartEvent(this, this.state, this.state, this.state, at, this.getMediaTime()));
            }
        }
        return true;
    }

    private boolean doStopAction() {
        switch (this.state) {
            case 600: {
                ControllerErrorEvent error = this.doStop(false);
                if (error == null) {
                    this.state = 500;
                    this.notifyListeners(new StopByRequestEvent(this, 600, 500, 500, this.getMediaTime()));
                    break;
                }
                this.notifyListeners(error);
                return false;
            }
            default: {
                this.notifyListeners(new StopByRequestEvent(this, this.state, this.state, this.state, this.getMediaTime()));
            }
        }
        return true;
    }

    private boolean doDeallocateAction() {
        switch (this.state) {
            case 200: {
                ControllerErrorEvent error = this.doDeallocate();
                if (error == null) {
                    this.state = 100;
                    this.notifyListeners(new DeallocateEvent(this, 200, 100, 100, this.getMediaTime()));
                    break;
                }
                this.notifyListeners(error);
                return false;
            }
            case 100: 
            case 300: {
                this.notifyListeners(new DeallocateEvent(this, this.state, this.state, this.state, this.getMediaTime()));
                break;
            }
            default: {
                ControllerErrorEvent error = this.doDeallocate();
                if (error == null) {
                    int previous = this.state;
                    this.state = 300;
                    this.notifyListeners(new DeallocateEvent(this, previous, 300, 300, this.getMediaTime()));
                    break;
                }
                this.notifyListeners(error);
                return false;
            }
        }
        return true;
    }

    private void doCloseAction() {
        this.doClose();
        this.notifyListeners(new ControllerClosedEvent(this));
        PlayerManager.getInstance().unregisterPlayer(this);
    }

    private static class PlayerAction
    extends BDJAction {
        private BDHandler player;
        private int action;
        private Object param;
        private int param2;
        public static final int ACTION_INIT = 1;
        public static final int ACTION_REALIZE = 2;
        public static final int ACTION_PREFETCH = 3;
        public static final int ACTION_START = 4;
        public static final int ACTION_STOP = 5;
        public static final int ACTION_DEALLOCATE = 6;
        public static final int ACTION_CLOSE = 7;
        public static final int ACTION_SEEK_TIME = 8;
        public static final int ACTION_SET_RATE = 9;
        public static final int ACTION_STATUS = 10;

        private PlayerAction(BDHandler player, int action, Object param) {
            this(player, action, param, -1);
        }

        private PlayerAction(BDHandler player, int action, Object param, int param2) {
            this.player = player;
            this.action = action;
            this.param = param;
            this.param2 = param2;
        }

        protected void doAction() {
            block0 : switch (this.action) {
                case 1: {
                    this.player.doInitAction();
                    break;
                }
                case 2: {
                    this.player.doRealizeAction();
                    break;
                }
                case 3: {
                    this.player.doPrefetchAction();
                    break;
                }
                case 4: {
                    this.player.doStartAction(this.param == null ? null : (Time)this.param);
                    break;
                }
                case 5: {
                    this.player.doStopAction();
                    break;
                }
                case 6: {
                    this.player.doDeallocateAction();
                    break;
                }
                case 7: {
                    this.player.doCloseAction();
                    break;
                }
                case 8: {
                    this.player.doSeekTime((Time)this.param);
                    break;
                }
                case 9: {
                    this.player.doSetRate((Float)this.param);
                    break;
                }
                case 10: {
                    switch ((Integer)this.param) {
                        case 6: {
                            this.player.doChapterReached(this.param2);
                            break block0;
                        }
                        case 7: {
                            this.player.doMarkReached(this.param2);
                            break block0;
                        }
                        case 5: {
                            this.player.doPlayItemReached(this.param2);
                            break block0;
                        }
                        case 4: {
                            this.player.doPlaylistStarted(this.param2);
                            break block0;
                        }
                        case 12: {
                            this.player.doAngleChanged(this.param2);
                            break block0;
                        }
                        case 14: {
                            this.player.doSubtitleChanged(this.param2);
                            break block0;
                        }
                        case 9: {
                            this.player.doEndOfMediaReached(this.param2);
                            break block0;
                        }
                        case 8: {
                            this.player.doTimeChanged(this.param2);
                            break block0;
                        }
                        case 13: {
                            this.player.doAudioStreamChanged(this.param2);
                            break block0;
                        }
                        case 15: {
                            this.player.doSecondaryStreamChanged(this.param2);
                            break block0;
                        }
                        case 17: {
                            this.player.doUOMasked(this.param2);
                            break block0;
                        }
                        case 10: {
                            this.player.doSeekNotify(this.param2 * 2);
                            break block0;
                        }
                        case 11: {
                            float rate = (float)this.param2 / 90000.0f;
                            if (rate < 0.0f) {
                                rate = -rate;
                            }
                            if (rate < 0.01f) {
                                rate = 0.0f;
                            }
                            if (rate > 0.99f && rate < 1.01f) {
                                rate = 1.0f;
                            }
                            this.player.doRateChanged(rate);
                            break block0;
                        }
                    }
                    System.err.println("Unknown ACTION_STATUS: id " + this.param + ", value " + this.param2);
                    break;
                }
                default: {
                    System.err.println("Unknown action " + this.action);
                }
            }
        }
    }
}

