/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import jdk.Exported;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Event;
import jdk.jfr.EventType;
import jdk.jfr.Registered;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.EventClassBuilder;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

@Exported
public final class EventFactory {
    private static final long REGISTERED_ID = Type.getTypeId(Registered.class);
    private final Class<? extends Event> eventClass;
    private final MethodHandle constructorHandle;
    private final List<AnnotationElement> sanitizedAnnotation;
    private final List<ValueDescriptor> sanitizedFields;

    private EventFactory(Class<? extends Event> clazz, List<AnnotationElement> list, List<ValueDescriptor> list2) throws IllegalAccessException, NoSuchMethodException, SecurityException {
        this.constructorHandle = MethodHandles.lookup().unreflectConstructor(clazz.getConstructor(new Class[0]));
        this.eventClass = clazz;
        this.sanitizedAnnotation = list;
        this.sanitizedFields = list2;
    }

    public static EventFactory create(List<AnnotationElement> list, List<ValueDescriptor> list2) {
        Object object;
        Objects.requireNonNull(list2);
        Objects.requireNonNull(list);
        JVMSupport.ensureWithInternalError();
        Utils.checkRegisterPermission();
        List<AnnotationElement> list3 = Utils.sanitizeNullFreeList(list, AnnotationElement.class);
        List<ValueDescriptor> list4 = Utils.sanitizeNullFreeList(list2, ValueDescriptor.class);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (ValueDescriptor object32 : list4) {
            object = object32.getName();
            if (object32.isArray()) {
                throw new IllegalArgumentException("Array types are not allowed for fields");
            }
            if (!Type.isValidJavaFieldType(object32.getTypeName())) {
                throw new IllegalArgumentException(object32.getTypeName() + " is not a valid type for an event field");
            }
            if (!Type.isValidJavaIdentifier(object32.getName())) {
                throw new IllegalArgumentException((String)object + " is not a valid name for an event field");
            }
            if (hashSet.contains(object)) {
                throw new IllegalArgumentException("Name of fields must be unique. Found two instances of " + (String)object);
            }
            hashSet.add(object);
        }
        boolean bl = true;
        ArrayList<AnnotationElement> arrayList = new ArrayList<AnnotationElement>();
        for (AnnotationElement annotationElement : list3) {
            long noSuchMethodException = annotationElement.getTypeId();
            if (!annotationElement.isInBoot()) continue;
            if (noSuchMethodException == REGISTERED_ID) {
                if (!Boolean.FALSE.equals(annotationElement.getValue("value"))) continue;
                bl = false;
                continue;
            }
            arrayList.add(annotationElement);
        }
        arrayList.add(new AnnotationElement(Registered.class, false));
        object = new EventClassBuilder(arrayList, list4);
        Class<? extends Event> clazz = ((EventClassBuilder)object).build();
        if (bl) {
            MetadataRepository.getInstance().register(clazz, list3, list4);
        }
        try {
            return new EventFactory(clazz, list3, list4);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError("Could not accees constructor of generated event handler, " + illegalAccessException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError("Could not find constructor in generated event handler, " + noSuchMethodException.getMessage());
        }
    }

    public Event newEvent() {
        try {
            return this.constructorHandle.invoke();
        }
        catch (Throwable throwable) {
            throw new InstantiationError("Could not instantaite dynamically generated event class " + this.eventClass.getName() + ". " + throwable.getMessage());
        }
    }

    public EventType getEventType() {
        return EventType.getEventType(this.eventClass);
    }

    public void register() {
        MetadataRepository.getInstance().register(this.eventClass, this.sanitizedAnnotation, this.sanitizedFields);
    }

    public void unregister() {
        MetadataRepository.getInstance().unregister(this.eventClass);
    }
}

