/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tooling;

import com.azul.tooling.ConsumerManager;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

class Engine {
    private static final int MAX_EVENTS_COUNT = 10000;
    private static ConcurrentLinkedQueue<Object> events = new ConcurrentLinkedQueue();
    private static final AtomicInteger overflowCounter = new AtomicInteger(0);
    private static int watermarkCount = 10000;
    private static volatile boolean notifiedWatermarkReached;
    private static volatile boolean discardEvents;

    Engine() {
    }

    static void putObject(Object object) {
        if (discardEvents) {
            return;
        }
        if (events.size() > 10000) {
            overflowCounter.incrementAndGet();
            return;
        }
        events.add(object);
        Engine.checkWatermark();
    }

    static void consume(ConsumerManager.Consumer consumer) {
        Object object;
        notifiedWatermarkReached = false;
        int n = overflowCounter.getAndSet(0);
        if (n > 0) {
            consumer.notifyOverflow(n);
        }
        while ((object = events.poll()) != null) {
            consumer.notifyEvent(object);
        }
    }

    static void setNotificationWatermark(int n) {
        watermarkCount = n * 10000 / 100;
        Engine.checkWatermark();
    }

    static void setDiscarding(boolean bl) {
        discardEvents = bl;
    }

    private static void checkWatermark() {
        ConsumerManager.Consumer consumer;
        if (events.size() > watermarkCount && !notifiedWatermarkReached && (consumer = ConsumerManager.getConsumer()) != null) {
            notifiedWatermarkReached = true;
            consumer.notifyWatermarkReached();
        }
    }
}

