/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.AgentBase;
import com.azul.crs.client.JDKAccessFactory;
import com.azul.crs.client.Options;
import com.azul.crs.client.Utils;
import com.azul.crs.client.VMSupport;
import com.azul.crs.client.service.GCLogMonitor;
import com.azul.crs.client.service.JFRMonitor;
import com.azul.crs.client.service.VMLogMonitor;
import com.azul.crs.client.service.VMToolingClient;
import com.azul.crs.jar.ZipTools;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import sun.launcher.LauncherHelper;

public final class Agent001
extends AgentBase {
    private static final int FLUSH_THREAD_DEFAULT_PERIOD_MS = 1000;
    private static final int FLUSH_THREAD_FORCE_DEFAULT_PERIOD_MS = 1800000;
    private static Agent001 instance;
    private JFRMonitor jfrMonitor;
    private GCLogMonitor gclogMonitor;
    private VMLogMonitor vmlogMonitor;
    private VMSupport vmSupport;
    private VMToolingClient vmToolingClient;
    private static final String agentAuthPrefix = "agentAuth=";
    private int connectionPort;
    private int connectionSecret;
    private final AtomicReference<String> notifyToJavaCallAcceptedName = new AtomicReference();
    private Thread mainMethodUpdateThread;
    private final Lock mainMethodUpdateLock = new ReentrantLock();
    private int forceFlushTimeout = 1800000;

    public static void premain(String string, Instrumentation instrumentation) {
        if (instance != null) {
            throw new RuntimeException();
        }
        instance = new Agent001();
        if (string != null && string.startsWith(agentAuthPrefix)) {
            string = instance.initAgentConnectionInfo(string);
        }
        instance.init(string);
    }

    void init(String string) {
        super.init(string, this::isSupportedOption);
        try {
            Method method;
            this.vmSupport = VMSupport.init(this.connectionPort, this.connectionSecret);
            this.vmSupport.registerAgent(Agent001.class);
            Method method2 = Agent001.class.getMethod("notifyToJavaCall", String.class);
            this.vmSupport.registerCallback(VMSupport.CrsNotificationType.EVENT_TO_JAVA_CALL, method2);
            if (Options.notifyClassLoad.isYes()) {
                method = Agent001.class.getMethod("notifyClassLoad", String.class, byte[].class, byte[].class, Integer.TYPE, Integer.TYPE, String.class);
                this.vmSupport.registerCallback(VMSupport.CrsNotificationType.CRS_MESSAGE_CLASS_LOAD, method);
            }
            if (Options.notifyFirstCall.isYes()) {
                method = Agent001.class.getMethod("notifyFirstCall", Integer.TYPE, String.class);
                this.vmSupport.registerCallback(VMSupport.CrsNotificationType.CRS_MESSAGE_FIRST_CALL, method);
            }
            if (Options.sendJVMLogs.isYes()) {
                method = Agent001.class.getMethod("notifyVMLogEntry", String.class, String.class);
                this.vmSupport.registerCallback(VMSupport.CrsNotificationType.CRS_MESSAGE_VM_LOG_ENTRY, method);
            }
        }
        catch (IOException | NoSuchMethodException | SecurityException exception) {
            this.logger.error("Failed to initialize", exception);
            return;
        }
        if (Options.forceSyncTimeout.isSet()) {
            this.forceFlushTimeout = Options.forceSyncTimeout.getInt() * 1000;
        }
        this.finishInit(JDKAccessFactory.getAccessor());
    }

    @Override
    boolean startupSpecific0() {
        ZipTools.setJdkAccessor(JDKAccessFactory.getAccessor());
        return true;
    }

    @Override
    void startupSpecific1(long l) {
        if (Options.sendJVMLogs.isYes()) {
            this.jfrMonitor = JFRMonitor.getInstance(this.client.getVmEventConsumer(), Options.lifetimejfr.get());
        }
        VMCRSCapabilities vMCRSCapabilities = VMCRSCapabilities.init();
        if (Options.sendJVMLogs.isYes()) {
            if (vMCRSCapabilities.has(AgentBase.VMCRSCapability.POST_VM_LOG_EVENTS)) {
                this.vmlogMonitor = VMLogMonitor.getInstance(this.client.getVmEventConsumer());
            } else {
                this.gclogMonitor = GCLogMonitor.getInstance(this.client.getVmEventConsumer(), l);
            }
        }
        if (vMCRSCapabilities.has(AgentBase.VMCRSCapability.POST_VM_TOOLING_EVENT)) {
            this.vmToolingClient = VMToolingClient.getInstance(this.client.getVmEventConsumer());
            this.vmToolingClient.setJarLoadService(this.jarLoadService);
        }
        if (!vMCRSCapabilities.has(AgentBase.VMCRSCapability.POST_CLASS_LOAD_EVENTS) || !vMCRSCapabilities.has(AgentBase.VMCRSCapability.POST_JAR_LOAD_EVENTS)) {
            this.logger.error("VM capabilities missing mandatory events support", new Object[0]);
        }
        this.startServices(this.jfrMonitor, this.vmlogMonitor, this.gclogMonitor, this.vmToolingClient);
    }

    @Override
    void startupAgent(String string) {
        super.startupAgent(string);
        EventsFlusher.start();
    }

    @Override
    void teardownSpecific1(Utils.Deadline deadline) throws InterruptedException {
        if (deadline.applyIfNotExpired(l -> this.mainMethodUpdateLock.tryLock(l, TimeUnit.MILLISECONDS)).orElse(false).booleanValue()) {
            try {
                if (this.mainMethodUpdateThread != null) {
                    deadline.runIfNotExpired(l -> this.mainMethodUpdateThread.join(l));
                }
            }
            finally {
                this.mainMethodUpdateLock.unlock();
            }
        }
    }

    @Override
    void teardownSpecific2(Utils.Deadline deadline) {
        this.logger.debug("drain native queue", new Object[0]);
        EventsFlusher.stop(deadline);
        this.stopServices(deadline, this.vmToolingClient, this.jfrMonitor, this.vmlogMonitor, this.gclogMonitor);
    }

    @Override
    synchronized void shutdownAgent() {
        for (VMSupport.CrsNotificationType crsNotificationType : VMSupport.CrsNotificationType.values()) {
            this.vmSupport.enableEventNotifications(crsNotificationType, false);
        }
        this.vmSupport.disableCRS();
        super.shutdownAgent();
    }

    private String initAgentConnectionInfo(String string) {
        char c;
        int n;
        int n2 = string.length();
        for (n = agentAuthPrefix.length(); n < n2 && Character.isDigit(c = string.charAt(n)); ++n) {
            this.connectionPort = this.connectionPort * 10 + (c - 48);
        }
        if (n < n2 && string.charAt(n) == '+') {
            ++n;
            while (n < n2 && Character.isDigit(c = string.charAt(n))) {
                this.connectionSecret = this.connectionSecret * 10 + (c - 48);
                ++n;
            }
        }
        if (n < n2 && string.charAt(n) == ',') {
            ++n;
        }
        return string.substring(n);
    }

    public static void notifyToJavaCall(String string) {
        instance.notifyJavaCallImpl(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyJavaCallImpl(String string) {
        Runnable runnable = null;
        if (string.startsWith("sun/launcher/LauncherHelper.checkAndLoadMain")) {
            runnable = () -> {
                try {
                    for (int i = 0; i < 10; ++i) {
                        if (instance.hardstop()) {
                            return;
                        }
                        Class<?> clazz = LauncherHelper.getApplicationClass();
                        if (clazz != null) {
                            this.mainMethodDetected(clazz.getName().replace('.', '/') + ".main");
                            return;
                        }
                        Thread.sleep(5L);
                    }
                    this.logger.warning("Failed to retrieve ApplicationClass", new Object[0]);
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                catch (Throwable throwable) {
                    this.logger.error("Internal error or unexpected problem. CRS defunct. %s", throwable);
                }
            };
        } else if (!(string.startsWith("apple/security/AppleProvider") || string.startsWith("java/") || string.startsWith("javax/") || string.startsWith("sun/") || string.startsWith("com/sun/") || string.startsWith("com/fasterxml") || string.startsWith("org/jcp") || string.startsWith("com/azul/crs") || string.startsWith("com/azul/tooling") || string.startsWith("jdk/"))) {
            runnable = () -> this.mainMethodDetected(string);
        }
        if (runnable != null) {
            if (!this.notifyToJavaCallAcceptedName.compareAndSet(null, string)) {
                this.logger.warning("notifyToJavaCall - name %s has been already accepted, skip %s", this.notifyToJavaCallAcceptedName.get(), string);
                return;
            }
            this.logger.debug("notifyToJavaCall name '%s' accepted.", string);
            this.vmSupport.enableEventNotifications(VMSupport.CrsNotificationType.EVENT_TO_JAVA_CALL, false);
            this.mainMethodUpdateLock.lock();
            try {
                Thread thread = new Thread(runnable, "CRSMainMethodUpdate");
                thread.setDaemon(true);
                thread.start();
                this.mainMethodUpdateThread = thread;
            }
            finally {
                this.mainMethodUpdateLock.unlock();
            }
        }
    }

    public static void notifyFirstCall(int n, String string) {
        if (!Options.notifyFirstCall.isYes()) {
            return;
        }
        Agent001.instance.firstCallMonitor.notifyMethodFirstCalled(n, string);
    }

    public static void notifyClassLoad(String string, byte[] byArray, byte[] byArray2, int n, int n2, String string2) {
        if (!Options.notifyClassLoad.isYes()) {
            return;
        }
        if (Agent001.instance.jarLoadService != null) {
            Agent001.instance.jarLoadService.notifyClassSourceSeen(string2);
        }
        Agent001.instance.classLoadMonitor.notifyClassLoad(string, byArray, byArray2, n, n2, string2);
    }

    public static void notifyVMLogEntry(String string, String string2) {
        Agent001.instance.vmlogMonitor.notifyVMLogEntry(string, string2);
    }

    private static final class EventsFlusher
    implements Runnable {
        private static volatile boolean stopped = false;
        private static Thread thread = null;
        private static final Object flushLock = new Object();
        private static final Object threadLock = new Object();

        private EventsFlusher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void start() {
            Object object = threadLock;
            synchronized (object) {
                if (thread != null || stopped) {
                    return;
                }
                thread = new Thread((Runnable)new EventsFlusher(), "CRSEventsFlushingThread");
                thread.setDaemon(true);
                thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void stop(Utils.Deadline deadline) {
            Object object = flushLock;
            synchronized (object) {
                stopped = true;
                flushLock.notify();
            }
            object = threadLock;
            synchronized (object) {
                try {
                    if (thread != null) {
                        deadline.runIfNotExpired(l -> thread.join(l));
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long l = Utils.currentTimeCount();
                while (true) {
                    boolean bl;
                    Object object = flushLock;
                    synchronized (object) {
                        try {
                            flushLock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                    if (stopped) break;
                    boolean bl2 = bl = Utils.elapsedTimeMillis(l) >= (long)instance.forceFlushTimeout;
                    if (bl) {
                        l = Utils.currentTimeCount();
                    }
                    instance.vmSupport.drainQueues(bl, false);
                }
                instance.vmSupport.drainQueues(true, true);
            }
            catch (Throwable throwable) {
                instance.logger.error("Internal error or unexpected problem. CRS defunct. %s", throwable);
            }
        }
    }

    private static final class VMCRSCapabilities {
        private final Set<AgentBase.VMCRSCapability> capabilities;

        private VMCRSCapabilities(Set<AgentBase.VMCRSCapability> set) {
            this.capabilities = Collections.unmodifiableSet(set);
            instance.logger.trace("Active VMCRSCapabilities: " + this.capabilities, new Object[0]);
        }

        private boolean has(AgentBase.VMCRSCapability vMCRSCapability) {
            return this.capabilities.contains((Object)vMCRSCapability);
        }

        private static VMCRSCapabilities init() {
            HashSet<AgentBase.VMCRSCapability> hashSet = new HashSet<AgentBase.VMCRSCapability>();
            try {
                if (VMToolingClient.isToolingImplemented()) {
                    hashSet.addAll(Arrays.asList(AgentBase.VMCRSCapability.POST_VM_TOOLING_EVENT, AgentBase.VMCRSCapability.POST_JAR_LOAD_EVENTS));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] stringArray = instance.vmSupport.getVMCRSCapabilities();
            if (stringArray != null) {
                for (String string : stringArray) {
                    try {
                        hashSet.add(AgentBase.VMCRSCapability.valueOf(string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        instance.logger.trace("VM reported unknown capability: " + string, new Object[0]);
                    }
                }
            } else {
                hashSet.addAll(Arrays.asList(AgentBase.VMCRSCapability.POST_CLASS_LOAD_EVENTS, AgentBase.VMCRSCapability.POST_FIRST_CALL_EVENTS, AgentBase.VMCRSCapability.POST_NOTIFY_TO_JAVA_CALLS));
            }
            return new VMCRSCapabilities(hashSet);
        }
    }
}

