/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.BDGraphics;
import java.awt.Font;
import java.io.File;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.videolan.Logger;
import sun.font.FontDesignMetrics;

public class BDFontMetrics
extends FontDesignMetrics {
    static final long serialVersionUID = -4956160226949100590L;
    private static long ftLib = 0L;
    private static long fcLib = 0L;
    private static Map systemFontNameMap = null;
    private static final Logger logger = Logger.getLogger((String)BDFontMetrics.class.getName());
    private static Map fontMetricsMap = new HashMap();
    private long ftFace = 0L;
    private int ascent = 0;
    private int descent = 0;
    private int leading = 0;
    private int maxAdvance = 0;
    private int[] widths;
    private final Object faceLock = new Object();

    private static native long initN();

    private static native void destroyN(long var0);

    private static native String[] getFontFamilyAndStyleN(long var0, String var2);

    protected static synchronized String[] getFontFamilyAndStyle(String fontFile) {
        return BDFontMetrics.getFontFamilyAndStyleN(ftLib, fontFile);
    }

    private static native String resolveFontN(String var0, int var1);

    private static native void unloadFontConfigN();

    private static void addSystemFont(String alias, int style, String family, String defaultPath) {
        alias = alias + "." + style;
        if (new File(defaultPath).exists()) {
            logger.info("mapping " + alias + " (" + family + ") to " + defaultPath);
            systemFontNameMap.put(alias, defaultPath);
            return;
        }
        String path = BDFontMetrics.resolveFontN(family, style);
        if (path != null) {
            logger.info("fontconfig: mapping " + alias + " (" + family + ") to " + path);
            systemFontNameMap.put(alias, path);
            return;
        }
        logger.error("Can't resolve font " + alias + ": file " + defaultPath + " does not exist");
        systemFontNameMap.put(alias, defaultPath);
    }

    private static void initSystemFonts() {
        String javaHome = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.home");
            }
        });
        File f = new File(javaHome, "lib" + File.separator + "fonts");
        String defaultFontPath = f.getAbsolutePath() + File.separator;
        Object[][] sfd = new Object[][]{{"serif", "Arial", new String[]{"LucidaBrightRegular.ttf", "LucidaBrightDemiBold.ttf", "LucidaBrightItalic.ttf", "LucidaBrightDemiItalic.ttf"}}, {"sansserif", "Times New Roman", new String[]{"LucidaSansRegular.ttf", "LucidaSansDemiBold.ttf", "LucidaSansOblique.ttf", "LucidaSansDemiOblique.ttf"}}, {"monospaced", "Courier New", new String[]{"LucidaTypewriterRegular.ttf", "LucidaTypewriterBold.ttf", "LucidaTypewriterOblique.ttf", "LucidaTypewriterBoldOblique.ttf"}}, {"dialog", "Times New Roman", new String[]{"LucidaSansRegular.ttf", "LucidaSansDemiBold.ttf", "LucidaSansOblique.ttf", "LucidaSansDemiOblique.ttf"}}, {"dialoginput", "Courier New", new String[]{"LucidaTypewriterRegular.ttf", "LucidaTypewriterBold.ttf", "LucidaTypewriterOblique.ttf", "LucidaTypewriterBoldOblique.ttf"}}, {"default", "Times New Roman", new String[]{"LucidaSansRegular.ttf", "LucidaSansDemiBold.ttf", "LucidaSansOblique.ttf", "LucidaSansDemiOblique.ttf"}}};
        systemFontNameMap = new HashMap(24);
        for (int type = 0; type < sfd.length; ++type) {
            for (int style = 0; style < 4; ++style) {
                BDFontMetrics.addSystemFont((String)sfd[type][0], style, (String)sfd[type][1], defaultFontPath + ((String[])sfd[type][2])[style]);
            }
        }
        BDFontMetrics.unloadFontConfigN();
    }

    public static synchronized void init() {
        if (ftLib == 0L) {
            ftLib = BDFontMetrics.initN();
        }
        if (ftLib == 0L) {
            logger.error("freetype library not loaded");
            throw new AWTError("freetype lib not loaded");
        }
        if (systemFontNameMap == null) {
            BDFontMetrics.initSystemFonts();
        }
    }

    public static synchronized void shutdown() {
        Iterator it = fontMetricsMap.values().iterator();
        while (it.hasNext()) {
            try {
                WeakReference ref = (WeakReference)it.next();
                BDFontMetrics fm = (BDFontMetrics)ref.get();
                it.remove();
                if (fm == null) continue;
                fm.destroy();
            }
            catch (Exception e) {
                logger.error("shutdown() failed: " + e);
            }
        }
        BDFontMetrics.destroyN(ftLib);
        ftLib = 0L;
    }

    static synchronized BDFontMetrics getFontMetrics(Font font) {
        BDFontMetrics fm = (BDFontMetrics)font.metrics;
        if (fm == null || fm.ftFace == 0L) {
            String nativeName;
            if (font.fontFile != null) {
                nativeName = font.fontFile.getPath();
            } else {
                nativeName = (String)systemFontNameMap.get(font.getName().toLowerCase() + "." + font.getStyle());
                if (nativeName == null) {
                    nativeName = (String)systemFontNameMap.get("default." + font.getStyle());
                }
            }
            String key = nativeName + "." + font.getSize();
            WeakReference ref = (WeakReference)fontMetricsMap.get(key);
            if (ref != null) {
                fm = (BDFontMetrics)ref.get();
            }
            if (fm == null) {
                fm = new BDFontMetrics(font, nativeName);
                fontMetricsMap.put(key, new WeakReference<BDFontMetrics>(fm));
            }
            font.metrics = fm;
        }
        return fm;
    }

    static String stripAttributes(String fontname) {
        int dotidx = fontname.indexOf(46);
        if (dotidx == -1) {
            return fontname;
        }
        return fontname.substring(0, dotidx);
    }

    static synchronized String[] getFontList() {
        try {
            BDFontMetrics.init();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            logger.error("getFontList() failed: " + t);
            return new String[0];
        }
        ArrayList<String> fontNames = new ArrayList<String>();
        Iterator fonts = systemFontNameMap.keySet().iterator();
        while (fonts.hasNext()) {
            String fontname = BDFontMetrics.stripAttributes((String)fonts.next());
            if (fontNames.contains(fontname)) continue;
            fontNames.add(fontname);
        }
        return fontNames.toArray(new String[fontNames.size()]);
    }

    private BDFontMetrics(Font font, String nativeName) {
        super(font);
        this.ftFace = this.loadFontN(ftLib, nativeName, font.getSize());
        if (this.ftFace == 0L) {
            logger.error("Error loading font");
            throw new AWTError("font face:" + nativeName + " not loaded");
        }
        this.widths = null;
    }

    private native long loadFontN(long var1, String var3, int var4);

    private native void destroyFontN(long var1);

    private native int charWidthN(long var1, char var3);

    private native int stringWidthN(long var1, String var3);

    private native int charsWidthN(long var1, char[] var3, int var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWidths() {
        if (this.widths == null) {
            int[] widths = new int[256];
            Object object = this.faceLock;
            synchronized (object) {
                for (int i = 0; i < 256; ++i) {
                    widths[i] = this.charWidthN(this.ftFace, (char)i);
                }
            }
            this.widths = widths;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawString(BDGraphics g, String string, int x, int y, int rgb) {
        Object object = this.faceLock;
        synchronized (object) {
            g.drawStringN(this.ftFace, string, x, y, rgb);
        }
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLeading() {
        return this.leading;
    }

    public int getMaxAdvance() {
        return this.maxAdvance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int charWidth(char c) {
        if (c < '\u0100') {
            this.loadWidths();
            return this.widths[c];
        }
        Object object = this.faceLock;
        synchronized (object) {
            return this.charWidthN(this.ftFace, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stringWidth(String string) {
        Class<BDFontMetrics> clazz = BDFontMetrics.class;
        synchronized (BDFontMetrics.class) {
            Object object = this.faceLock;
            synchronized (object) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.stringWidthN(this.ftFace, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int charsWidth(char[] chars, int offset, int length) {
        Object object = this.faceLock;
        synchronized (object) {
            return this.charsWidthN(this.ftFace, chars, offset, length);
        }
    }

    public int[] getWidths() {
        this.loadWidths();
        int[] newWidths = new int[this.widths.length];
        System.arraycopy(this.widths, 0, newWidths, 0, this.widths.length);
        return newWidths;
    }

    private void destroy() {
        if (this.ftFace != 0L) {
            this.destroyFontN(this.ftFace);
            this.ftFace = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            super.finalize();
        }
    }

    static {
        FontDesignMetrics.setGetFontMetricsAccess(new FontDesignMetrics.GetFontMetricsAccess(){

            public FontDesignMetrics getFontMetrics(Font font) {
                return BDFontMetrics.getFontMetrics(font);
            }
        });
    }
}

