/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.models;

import com.azul.crs.client.Utils;
import com.azul.crs.client.models.Payload;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.models.VMInstance;
import com.azul.crs.util.logging.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class VMEvent
extends Payload {
    private String vmId;
    private String eventId;
    private Type eventType;
    private Long eventTime;
    private Object eventPayload;
    private transient Runnable onError;
    private transient Runnable onSuccess;

    public String getVmId() {
        return this.vmId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Type getEventType() {
        return this.eventType;
    }

    public Long getEventTime() {
        return this.eventTime;
    }

    public <T> T getEventPayload() {
        return (T)this.eventPayload;
    }

    public void setVmId(String string) {
        this.vmId = string;
    }

    public void setEventId(String string) {
        this.eventId = string;
    }

    public void setEventTime(Long l) {
        this.eventTime = l;
    }

    public void setEventType(Type type) {
        if (this.eventPayload != null && !type.payloadClass().isAssignableFrom(this.eventPayload.getClass())) {
            throw new IllegalArgumentException("Event type inconsistent with event payload type");
        }
        this.eventType = type;
    }

    public void setEventPayload(Object object) {
        if (this.eventType != null && !this.eventType.payloadClass().isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Event payload type inconsistent with event type ");
        }
        this.eventPayload = object;
    }

    public VMEvent vmId(String string) {
        this.setVmId(string);
        return this;
    }

    public VMEvent eventId(String string) {
        this.setEventId(string);
        return this;
    }

    public VMEvent randomEventId() {
        this.setEventId(Utils.uuid());
        return this;
    }

    public VMEvent eventType(Type type) {
        this.setEventType(type);
        return this;
    }

    public VMEvent eventType(String string) {
        this.setEventType(Type.valueOf(string));
        return this;
    }

    public VMEvent eventTime(Long l) {
        this.setEventTime(l);
        return this;
    }

    public VMEvent eventPayload(Object object) {
        this.setEventPayload(object);
        return this;
    }

    public VMEvent onError(Runnable runnable) {
        if (this.onError != null) {
            throw new RuntimeException("onError non-null");
        }
        this.onError = runnable;
        return this;
    }

    public VMEvent onSuccess(Runnable runnable) {
        if (this.onSuccess != null) {
            throw new RuntimeException("onSuccess non-null");
        }
        this.onSuccess = runnable;
        return this;
    }

    public VMEvent onErrorAppend(Function<Runnable, Runnable> function) {
        this.onError = function.apply(this.onError);
        return this;
    }

    public VMEvent onSuccessAppend(Function<Runnable, Runnable> function) {
        this.onSuccess = function.apply(this.onSuccess);
        return this;
    }

    public void callOnError() {
        if (this.onError != null) {
            this.onError.run();
        }
    }

    public void callOnSuccess() {
        if (this.onSuccess != null) {
            this.onSuccess.run();
        }
    }

    public static Iterator<Payload.DataWithCounters> toJsonArrays(final Collection<? extends VMEvent> collection, final int n) {
        return new Iterator<Payload.DataWithCounters>(){
            Iterator<? extends VMEvent> it;
            StringBuilder current;
            StringBuilder sb;
            Map<Type, Long> counters;
            Type currentEventType;
            {
                this.it = collection.iterator();
                this.current = new StringBuilder();
                this.sb = new StringBuilder().append('[');
                this.counters = new HashMap<Type, Long>();
                this.currentEventType = null;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext() || this.current.length() > 0;
            }

            @Override
            public Payload.DataWithCounters next() {
                this.counters.clear();
                this.sb.setLength(1);
                this.fillNext();
                this.sb.setCharAt(this.sb.length() - 1, ']');
                return new Payload.DataWithCounters(this.sb.toString(), this.counters);
            }

            private void fillNext() {
                if (this.current.length() > 0) {
                    this.sb.append((CharSequence)this.current).append(',');
                    this.counters.compute(this.currentEventType, (type, l) -> l == null ? 1L : l + 1L);
                    this.current.setLength(0);
                }
                if (this.sb.length() < n) {
                    while (this.it.hasNext()) {
                        VMEvent vMEvent = this.it.next();
                        this.currentEventType = vMEvent.getEventType();
                        Utils.serializer.serialize(this.current, (Object)vMEvent);
                        if (this.sb.length() + this.current.length() + 1 >= n) {
                            if (this.current.length() + 2 >= n) {
                                Logger.getLogger(Payload.class).error("Single event must not exceed %d. Current event '%s...' has length %d. The event is skipped.", n, this.current.subSequence(0, Math.min(this.current.length(), 100)).toString(), this.current.length());
                                this.current.setLength(0);
                            }
                            return;
                        }
                        this.sb.append((CharSequence)this.current).append(',');
                        this.counters.compute(this.currentEventType, (type, l) -> l == null ? 1L : l + 1L);
                        this.current.setLength(0);
                    }
                }
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VMEvent vMEvent = (VMEvent)object;
        return Objects.equals(this.vmId, vMEvent.vmId) && Objects.equals(this.eventId, vMEvent.eventId) && this.eventType == vMEvent.eventType && Objects.equals(this.eventTime, vMEvent.eventTime) && Objects.equals(this.eventPayload, vMEvent.eventPayload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vmId, this.eventId, this.eventType, this.eventTime, this.eventPayload});
    }

    @Override
    public String toString() {
        return "vmId=" + this.vmId + ", eventId=" + this.eventId + ", eventType=" + (Object)((Object)this.eventType) + ", eventTime=" + this.eventTime + ", eventPayload=" + this.eventPayload + ", onSuccessIsSet=" + (this.onSuccess != null) + ", onErrorIsSet=" + (this.onSuccess != null);
    }

    public static enum Type {
        VM_CREATE(VMInstance.class),
        VM_PATCH(VMInstance.class),
        VM_ARTIFACT_CREATE(VMArtifact.class),
        VM_ARTIFACT_PATCH(VMArtifact.class),
        VM_ARTIFACT_DATA(Map.class),
        VM_HEARTBEAT(Void.class),
        VM_SHUTDOWN(Void.class),
        VM_CLASS_LOADED(Map.class),
        VM_JAR_LOADED(Map.class),
        VM_METHOD_FIRST_CALLED(Map.class),
        VM_PERFORMANCE_METRICS(Map.class),
        VM_ANY_CONNECTION(Object.class);

        private final Class payloadClass;
        private int inFlightEventsCount = 0;

        private Type(Class clazz) {
            this.payloadClass = clazz;
        }

        public Class payloadClass() {
            return this.payloadClass;
        }

        public static Type eventType(String string) {
            return string != null ? Type.valueOf(string.toUpperCase()) : null;
        }

        public synchronized int getInFlightEventsCounter() {
            return this.inFlightEventsCount;
        }

        public synchronized int incrementInFlightEventsCount() {
            ++this.inFlightEventsCount;
            return this.inFlightEventsCount;
        }

        public synchronized int subtractInFlightEventsCount(int n) {
            this.inFlightEventsCount -= n;
            if (this.inFlightEventsCount == 0) {
                ((Object)((Object)this)).notifyAll();
            }
            return this.inFlightEventsCount;
        }

        public synchronized void waitAllEventsProcessed(Utils.Deadline deadline) throws InterruptedException {
            while (this.inFlightEventsCount != 0 && !deadline.hasExpired()) {
                ((Object)((Object)this)).wait(Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS)));
            }
        }
    }
}

