/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.awt.Container;
import java.io.File;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.util.Enumeration;
import javax.media.Manager;
import org.bluray.net.BDLocator;
import org.bluray.ti.TitleImpl;
import org.davic.media.MediaLocator;
import org.dvb.application.AppID;
import org.dvb.application.AppsDatabase;
import org.dvb.application.CurrentServiceFilter;
import org.videolan.BDJAction;
import org.videolan.BDJActionManager;
import org.videolan.BDJActionQueue;
import org.videolan.BDJAppProxy;
import org.videolan.BDJAppsDatabase;
import org.videolan.BDJLoaderAdapter;
import org.videolan.BDJLoaderCallback;
import org.videolan.BDJXletContext;
import org.videolan.GUIManager;
import org.videolan.Libbluray;
import org.videolan.Logger;
import org.videolan.StrUtil;
import org.videolan.TitleInfo;
import org.videolan.VFSCache;
import org.videolan.bdjo.AppEntry;
import org.videolan.bdjo.Bdjo;
import org.videolan.bdjo.GraphicsResolution;
import org.videolan.bdjo.PlayListTable;
import org.videolan.bdjo.TerminalInfo;
import org.videolan.media.content.PlayerManager;

public class BDJLoader {
    private static final Logger logger = Logger.getLogger(BDJLoader.class.getName());
    private static BDJActionQueue queue = null;
    private static VFSCache vfsCache = null;

    public static File addFont(InputStream is) {
        if (BDJXletContext.getCurrentContext() == null) {
            return BDJLoader.addFontImpl(is);
        }
        return new FontCacheAction(is).execute();
    }

    public static File addFont(String fontFile) {
        if (BDJXletContext.getCurrentContext() == null) {
            return BDJLoader.addFontImpl(fontFile);
        }
        return new FontCacheAction(fontFile).execute();
    }

    private static File addFontImpl(InputStream is) {
        VFSCache localCache = vfsCache;
        if (localCache != null) {
            return localCache.addFont(is);
        }
        return null;
    }

    private static File addFontImpl(String fontFile) {
        VFSCache localCache = vfsCache;
        if (localCache != null) {
            return localCache.addFont(fontFile);
        }
        return null;
    }

    protected static void accessFile(String file) {
        VFSCache localCache = vfsCache;
        if (localCache != null) {
            localCache.accessFile(file);
        }
    }

    public static String getCachedFile(String path) {
        VFSCache localCache = vfsCache;
        if (localCache != null) {
            return localCache.map(path);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean load(TitleImpl title, boolean restart, BDJLoaderCallback callback) {
        if (title == null) {
            return false;
        }
        Class<BDJLoader> clazz = BDJLoader.class;
        synchronized (BDJLoader.class) {
            if (queue == null) {
                queue = BDJActionQueue.create("BDJLoader");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            queue.put(new BDJLoaderAction(title, restart, callback));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unload(BDJLoaderCallback callback) {
        Class<BDJLoader> clazz = BDJLoader.class;
        synchronized (BDJLoader.class) {
            if (queue == null) {
                queue = BDJActionQueue.create("BDJLoader");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            queue.put(new BDJLoaderAction(null, false, callback));
            return true;
        }
    }

    protected static void shutdown() {
        try {
            if (queue != null) {
                queue.shutdown();
            }
        }
        catch (Throwable e) {
            logger.error("shutdown() failed: " + e + "\n" + Logger.dumpStack(e));
        }
        queue = null;
        vfsCache = null;
    }

    private static boolean loadN(TitleImpl title, boolean restart) {
        TitleInfo ti;
        if (vfsCache == null) {
            vfsCache = VFSCache.createInstance();
        }
        if (!(ti = title.getTitleInfo()).isBdj()) {
            logger.info("Not BD-J title - requesting HDMV title start");
            BDJLoader.unloadN();
            return Libbluray.selectHdmvTitle(title.getTitleNum());
        }
        try {
            Bdjo bdjo = Libbluray.getBdjo(ti.getBdjoName());
            if (bdjo == null) {
                throw new InvalidObjectException("bdjo not loaded");
            }
            AppEntry[] appTable = bdjo.getAppTable();
            BDJAppProxy[] proxys = new BDJAppProxy[appTable.length];
            AppsDatabase db = AppsDatabase.getAppsDatabase();
            Enumeration ids = db.getAppIDs(new CurrentServiceFilter());
            while (ids.hasMoreElements()) {
                AppID id = (AppID)ids.nextElement();
                BDJAppProxy proxy = (BDJAppProxy)db.getAppProxy(id);
                AppEntry entry = (AppEntry)db.getAppAttributes(id);
                if (proxy == null) {
                    logger.error("AppsDatabase corrupted!");
                    continue;
                }
                if (entry == null) {
                    logger.error("AppsDatabase corrupted!");
                    proxy.release();
                    continue;
                }
                for (int i = 0; i < appTable.length; ++i) {
                    if (!id.equals(appTable[i].getIdentifier()) || !entry.getInitialClass().equals(appTable[i].getInitialClass())) continue;
                    if (restart && appTable[i].getIsServiceBound()) {
                        logger.info("Stopping xlet " + appTable[i].getInitialClass() + " (for restart)");
                        proxy.stop(true);
                        break;
                    }
                    logger.info("Keeping xlet " + appTable[i].getInitialClass());
                    proxys[i] = proxy;
                    proxy = null;
                    break;
                }
                if (proxy == null) continue;
                logger.info("Terminating xlet " + entry.getInitialClass());
                proxy.release();
            }
            GUIManager gui = GUIManager.createInstance();
            TerminalInfo terminfo = bdjo.getTerminalInfo();
            GraphicsResolution res = terminfo.getResolution();
            gui.setDefaultFont(terminfo.getDefaultFont());
            gui.setResizable(true);
            gui.setSize(res.getWidth(), res.getHeight());
            gui.setVisible(true);
            Libbluray.setUOMask(terminfo.getMenuCallMask(), terminfo.getTitleSearchMask());
            Libbluray.setKeyInterest(bdjo.getKeyInterestTable());
            if (vfsCache != null) {
                vfsCache.add(bdjo.getAppCaches());
            }
            try {
                BDJLoaderAdapter a = Libbluray.getLoaderAdapter();
                if (a != null) {
                    appTable = a.patchAppTable(appTable, title.getTitleNum());
                }
            }
            catch (Throwable t) {
                logger.error("" + t);
            }
            for (int i = 0; i < appTable.length; ++i) {
                if (proxys[i] == null) {
                    proxys[i] = BDJAppProxy.newInstance(new BDJXletContext(appTable[i], bdjo.getAppCaches(), (Container)((Object)gui)));
                    String[] params = appTable[i].getParams();
                    String p = "";
                    if (params != null && params.length > 0) {
                        p = "(" + StrUtil.Join(params, ",") + ")";
                    }
                    logger.info("Loaded class: " + appTable[i].getInitialClass() + p + " from " + appTable[i].getBasePath() + ".jar");
                    continue;
                }
                proxys[i].getXletContext().update(appTable[i], bdjo.getAppCaches());
                logger.info("Reused class: " + appTable[i].getInitialClass() + " from " + appTable[i].getBasePath() + ".jar");
            }
            Libbluray.writePSR(4, title.getTitleNum());
            ((BDJAppsDatabase)BDJAppsDatabase.getAppsDatabase()).newDatabase(bdjo, proxys);
            try {
                PlayListTable plt = bdjo.getAccessiblePlaylists();
                if (plt != null && plt.isAutostartFirst()) {
                    logger.info("Auto-starting playlist");
                    String[] pl = plt.getPlayLists();
                    if (pl.length > 0) {
                        Manager.createPlayer(new MediaLocator(new BDLocator("bd://PLAYLIST:" + pl[0]))).start();
                    }
                }
            }
            catch (Exception e) {
                logger.error("loadN(): autoplaylist failed: " + e + "\n" + Logger.dumpStack(e));
            }
            for (int i = 0; i < appTable.length; ++i) {
                int code = appTable[i].getControlCode();
                if (code == 1) {
                    logger.info("Autostart xlet " + i + ": " + appTable[i].getInitialClass());
                    proxys[i].start();
                    continue;
                }
                if (code == 2) {
                    logger.info("Init xlet " + i + ": " + appTable[i].getInitialClass());
                    proxys[i].init();
                    continue;
                }
                logger.info("Unsupported xlet code (" + code + ") xlet " + i + ": " + appTable[i].getInitialClass());
            }
            logger.info("Finished initializing and starting xlets.");
            return true;
        }
        catch (Throwable e) {
            logger.error("loadN() failed: " + e + "\n" + Logger.dumpStack(e));
            BDJLoader.unloadN();
            return false;
        }
    }

    private static boolean unloadN() {
        try {
            BDJAppProxy proxy;
            AppID id;
            try {
                GUIManager.getInstance().setVisible(false);
            }
            catch (Error error) {
                // empty catch block
            }
            AppsDatabase db = AppsDatabase.getAppsDatabase();
            Enumeration ids = db.getAppIDs(new CurrentServiceFilter());
            while (ids.hasMoreElements()) {
                id = (AppID)ids.nextElement();
                proxy = (BDJAppProxy)db.getAppProxy(id);
                if (proxy == null) continue;
                proxy.stop(true);
            }
            ids = db.getAppIDs(new CurrentServiceFilter());
            while (ids.hasMoreElements()) {
                id = (AppID)ids.nextElement();
                proxy = (BDJAppProxy)db.getAppProxy(id);
                if (proxy == null) continue;
                proxy.release();
            }
            ((BDJAppsDatabase)db).newDatabase(null, null);
            PlayerManager.getInstance().releaseAllPlayers(true);
            return true;
        }
        catch (Throwable e) {
            logger.error("unloadN() failed: " + e + "\n" + Logger.dumpStack(e));
            return false;
        }
    }

    private static class BDJLoaderAction
    extends BDJAction {
        private TitleImpl title;
        private boolean restart;
        private BDJLoaderCallback callback;

        public BDJLoaderAction(TitleImpl title, boolean restart, BDJLoaderCallback callback) {
            this.title = title;
            this.restart = restart;
            this.callback = callback;
        }

        protected void doAction() {
            boolean succeed = this.title != null ? BDJLoader.loadN(this.title, this.restart) : BDJLoader.unloadN();
            if (this.callback != null) {
                this.callback.loaderDone(succeed);
            }
        }
    }

    private static class FontCacheAction
    extends BDJAction {
        private final String fontPath;
        private final InputStream is;
        private File cacheFile = null;
        private RuntimeException exception = null;

        public FontCacheAction(InputStream is) {
            this.fontPath = null;
            this.is = is;
        }

        public FontCacheAction(String fontPath) {
            this.fontPath = fontPath;
            this.is = null;
        }

        protected void doAction() {
            try {
                this.cacheFile = this.is != null ? BDJLoader.addFontImpl(this.is) : BDJLoader.addFontImpl(this.fontPath);
            }
            catch (RuntimeException e) {
                this.exception = e;
            }
        }

        public File execute() {
            BDJActionManager.getInstance().putCommand(this);
            this.waitEnd();
            if (this.exception != null) {
                throw this.exception;
            }
            return this.cacheFile;
        }
    }
}

