/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.sysinfo;

import com.azul.crs.client.sysinfo.SystemInfoProvider;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

final class LinuxSystemInfoProvider
extends SystemInfoProvider.SystemInfoProviderImpl {
    LinuxSystemInfoProvider() {
    }

    @Override
    protected void initProps() throws IOException, InterruptedException {
        String string;
        String string2;
        String string3;
        int n = 0;
        int n2 = 0;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader("/proc/cpuinfo"));){
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.isEmpty()) {
                    ++n2;
                    continue;
                }
                if (n2 == 0) {
                    if ((n >= string3.length() || string3.charAt(n) != ':') && (n = string3.indexOf(58)) < 0) {
                        n = 0;
                        continue;
                    }
                    string2 = "proc.cpuinfo." + string3.substring(0, n).trim();
                    string = string3.substring(n + 1).trim();
                    this.machdepProps.set(string2, string);
                    if (!string3.startsWith("cpu MHz")) continue;
                    string7 = string;
                    continue;
                }
                if (string3.startsWith("processor")) {
                    string6 = string3;
                    continue;
                }
                if (string3.startsWith("physical id")) {
                    string4 = string3;
                    continue;
                }
                if (!string3.startsWith("core id")) continue;
                string5 = string3;
            }
        }
        bufferedReader = new BufferedReader(new FileReader("/proc/meminfo"));
        var8_8 = null;
        try {
            while ((string3 = bufferedReader.readLine()) != null) {
                n = string3.indexOf(58);
                if (n < 0) {
                    break;
                }
                string2 = "proc.meminfo." + string3.substring(0, n).trim();
                string = string3.substring(n + 1).trim();
                this.machdepProps.set(string2, string);
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (bufferedReader != null) {
                if (var8_8 != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    bufferedReader.close();
                }
            }
        }
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PROCESSOR_COUNT, 1 + this.parseIntOrZero(string6.substring(1 + string6.lastIndexOf(32))));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.VENDOR, this.machdepProps.strValue("proc.cpuinfo.vendor_id"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.MODEL_NAME, this.machdepProps.strValue("proc.cpuinfo.model name"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PHYSICAL_CORE_COUNT, 1 + this.parseIntOrZero(string5.substring(1 + string5.lastIndexOf(32))));
    }

    private static String firstLine(String string) {
        try {
            return Files.readAllLines(Paths.get(string, new String[0])).get(0);
        }
        catch (IOException | RuntimeException exception) {
            return "";
        }
    }

    private String cacheSize(String string) {
        try {
            if (string.endsWith("K")) {
                int n = Integer.parseInt(string.substring(0, string.length() - 1));
                return "" + (n << 10);
            }
            return string.trim();
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
    }

    private String frequency(String string) {
        try {
            return "" + (Long.parseLong(string.replace(".", "").trim()) << 10);
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
    }
}

